// compile with dxc -T ps_6_0 -E fragment -spirv simple.hlsl -Fo simple.spv

struct Push { uint idx; }; 

cbuffer UNIFOMS : register(b12) {
	float3 color;
};

[[vk::push_constant]] ConstantBuffer<Push> push;

SamplerState interpSampler : register(s13);
Texture2D simpleTexture : register(t0);

float4 fragment(noperspective centroid float2 fragcoord : TEXCOORD0) : SV_TARGET0 {
	float2 uv = fragcoord.xy;
	float3 col = color;
	float4 tex = simpleTexture.Sample(interpSampler, uv);
	
	return float4(tex.rgb * col * float(1 + push.idx), 1.0);
}
