#import "@preview/touying:0.6.1": *
#import "@preview/cetz:0.3.4"

#let cetz-canvas = touying-reducer.with(
  reduce: cetz.canvas,
  cover: cetz.draw.hide.with(bounds: true)
)

#import themes.metropolis: *

#set text(font: "DejaVu Sans")

#show figure.caption: it => it.body

#show: metropolis-theme.with(
  aspect-ratio: "4-3",
  config-info(
    title: [A fast and practical model for atmospheric scattering],
    author: [Author: Dimas Leenman \ Supervisor: Peter Vangorp],
    institution: [Utrecht University],
  ),
)

#title-slide()

= Motivation
Why model the sky?

== Motivation
#slide(repeat: 2, self => [
  #let (uncover, only) = utils.methods(self)

  #only(1, [Games that take place outside want to use a realistic sky])
  #only(2, [A skybox only works well for static scenes, with a fixed viewer])
  
  #figure(
    grid(
      rows: (auto, auto),
      columns: (auto, auto),
      gutter: 2em,
      image("msfs.png", width: 18em), image("ksp.png", width: 18em),
      image("fh5.png", width: 18em), image("sailwind.png", width: 18em)
    )
  )
])

== Motivation
Some games need both ground and space views!

#figure(
  grid(
    rows: (auto, auto),
    columns: (auto, auto),
    gutter: 2em,
    image("space-glider.png", width: 18em),
    image("space-glider-2.png", width: 18em),
    image("horizons.png", width: 18em),
    image("horizons-2.png", width: 18em)
  )
)

== Motivation
For this reason, we need a more complete model, that can simulate all views

#figure(
  grid(
    rows: (auto, auto),
    columns: (auto, auto),
    gutter: 2em,
    image("space-glider.png", width: 18em),
    image("space-glider-2.png", width: 18em),
    image("horizons.png", width: 18em),
    image("horizons-2.png", width: 18em)
  )
)

= Physics
Modeling the sky

== Scattering
#slide(repeat: 9, self => [
  #let (uncover, only) = utils.methods(self)

  #only(1, [This is a planet:])
  #only(2, [With an atmosphere:])
  #only(3, [And a viewer $v$:])
  #only(4, [And a light source $l$:])
  #only(5, [Light travels from $l$ through the atmosphere:])
  #only(6, [Then scatters towards $v$:])
  #only(7, [Then scatters towards $v$: Single scattering])
  #only(8, [Light can also scatter via other paths:])
  #only(9, [Light can also scatter via other paths: Multiple scattering])

  #figure(
    cetz.canvas(length: 2.5em, {
      import cetz.draw: *
      let self = utils.merge-dicts(
        self,
        config-methods(cover: utils.method-wrapper(hide.with(bounds: true))),
      )
      let (uncover,) = utils.methods(self)

      let ocontent(a, b, ..rest) = {
        content(a, { set text(size: 30pt); b }, ..rest)
      }

      stroke((thickness: 2pt))
      
      // planet
      arc-through((-5, -1), (0, 0), (5, -1))

      uncover("2-99", {
        // atmosphere
        stroke((dash: "dashed"))
        arc-through((-7.5, 1), (0, 3), (7.5, 1)) // atmosphere
        stroke((dash: none))
      })

      uncover("3-99", {
        // viewer
        fill(black)
        ocontent((-3.3, 0.7), [$v$])
        circle((-3, 1), radius: 0.1)
        fill(none)
      })

      uncover("4-99", {
        // sun
        stroke((dash: "dashed"))
        circle((5, 4), radius: 0.2)
        ocontent((5.4, 3.6), [$l$])
        stroke((dash: none))
      })

      uncover("6-99", {
        // view to scatter
        line((-3, 1), (1, 1))
      })

      uncover("5-99", {
        // scatter to sun
        line((1, 1), (5, 4))
      })
      
      uncover("8-99", {
        // scatter to sun, multiple
        stroke((dash: "dashed"))
        line((1, 1), (2, 1))
        line((2, 1), (3, 0))
        line((3, 0), (5, 4))
      })
    })
  )
])

== Light interaction
- When traveling through the atmosphere, light is absorbed
  #pause
- Absorption depends on _Optical Depth_ $tau$
  #pause
- Transmittance $T$ depends on Beer's law: $T = exp(-beta_a tau)$

== Light interaction
- Optical depth depends on density $rho(h)$
- Amount of particles in the light's path, starting at viewer height $h$, and going in direction $theta_v$:
  #pause
  $ tau = integral_a^b rho(sqrt(t^2 + h^2 + 2 h t cos theta_v)) d t $
  #pause
- Common value for $rho(h)$:
  $ rho(h) = exp(-h / h_0) $

== Light interaction
- Earth's atmosphere consists of multiple particle types, each with different distributions and scattering properties:
  #pause
- Mie scattering: larger particles, closer to the ground, does not change direction much
  #pause
- Rayleigh scattering: Smaller particles, scatters in a roughly uniform direction
  #pause
- Ozone absorption: Does not scatter, but absorbs light, in a layer at roughly 25km high

== Light interaction
- Scattering direction can be determined with a phase function:
- Phase function $F(theta_s)$ gives PDF of light scattering direction
  #pause
- For Mie scattering, Cornette-Shanks can be used:
  $ F(theta_s) = 3/(8pi)((1-g^2)(1+cos^2 theta_s))/((2+g^2)(1 + g^2 - 2g cos theta_s)^(3/2)) $
  #pause
- For Rayleigh scattering, We can assume $g=0$, or use the isotropic phase function $F(theta_s) = 1 / (4pi)$
  #pause
#figure(image("phase-plot.png"), caption: [Cornette-Shanks plotted for $g=0$, $g=0.4$, $g=0.6$])

== Light interaction
#slide(repeat: 3, self => [
  #let (uncover, only) = utils.methods(self)

  - #uncover("1-3", [We can now calculate radiance $L$ arriving at $v$])
    #uncover("2-3", [$ L_"scatter" = E_"light" F(theta_s) beta_s rho(h_s) T_s T_l $])
  #uncover("3-3", [- Integrate this over the full view path from the viewer])
  #figure(
    cetz.canvas(length: 2.5em, {
      import cetz.draw: *
  
      let ocontent(a, b, ..rest) = {
        content(a, { set text(size: 30pt); b }, ..rest)
      }
  
      stroke((thickness: 2pt))
      
      // planet
      arc-through((-5, -1), (0, 0), (5, -1))
  
      // atmosphere
      stroke((dash: "dashed"))
      arc-through((-7.5, 1), (0, 3), (7.5, 1)) // atmosphere
      stroke((dash: none))
  
      // viewer
      fill(black)
      ocontent((-3.3, 0.7), [$v$])
      circle((-3, 1), radius: 0.1)
      fill(none)
  
      // sun
      stroke((dash: "dashed"))
      circle((5, 4), radius: 0.2)
      ocontent((5.4, 3.6), [$l$])
      stroke((dash: none))
  
      // view to scatter
      line((-3, 1), (1, 1))
  
      // scatter to sun
      line((1, 1), (5, 4))
    })
  )
])

= Implementation
Various methods of computing radiance

== Path tracing
- Simulate full path of a single photon
  #pause
- Accurate but slow

== Path tracing
#slide(repeat: 4, self => [
  #let (uncover, only) = utils.methods(self)

  #only(1, [Start at the viewer])
  #only(2, [Use delta tracking to find the scatter point])
  #only(3, [Compute transmittance $T$ towards light $l$, using Ratio tracking])
  #only(4, [Randomly pick a new scattering direction, and repeat])

  #figure(
    cetz.canvas(length: 2.5em, {
      import cetz.draw: *
      let self = utils.merge-dicts(
        self,
        config-methods(cover: utils.method-wrapper(hide.with(bounds: true))),
      )
      let (uncover,) = utils.methods(self)

      let ocontent(a, b, ..rest) = {
        content(a, { set text(size: 30pt); b }, ..rest)
      }

      stroke((thickness: 2pt))
      
      // planet
      arc-through((-5, -1), (0, 0), (5, -1))

      uncover("1-99", {
        // atmosphere
        stroke((dash: "dashed"))
        arc-through((-7.5, 1), (0, 3), (7.5, 1)) // atmosphere
        stroke((dash: none))
      })

      uncover("1-99", {
        // viewer
        fill(black)
        ocontent((-3.3, 0.7), [$v$])
        circle((-3, 1), radius: 0.1)
        fill(none)
      })

      uncover("1-99", {
        // sun
        stroke((dash: "dashed"))
        circle((5, 4), radius: 0.2)
        ocontent((5.4, 3.6), [$l$])
        stroke((dash: none))
      })

      uncover("2-99", {
        // view to scatter
        line((-3, 1), (1, 1))
      })

      uncover("3-99", {
        // scatter to sun
        line((1, 1), (5, 4))
      })
      
      uncover("4-99", {
        // scatter to sun, multiple
        stroke((dash: "dashed"))
        line((1, 1), (2, 1))
        line((2, 1), (3, 0))
        line((3, 0), (5, 4))
      })
    })
  )
])

== Path tracing
Results:
#figure(
  grid(
    rows: (auto,),
    columns: (auto, auto),
    gutter: 2em,
    image("pt-space.png", width: 18em),
    image("pt-sunset.png", width: 18em)
  )
)

== Path tracing
This takes 12 seconds on my desktop, several minutes on my laptop

#pause

It also generates noise

#figure(image("pt-noise.png", width: 30em))

== Naive
Can we do faster?

#pause

Yes

== Naive
#slide(repeat: 4, self => [
  #let (uncover, only) = utils.methods(self)

  #uncover("1-3", [Recall single scattering:])
  #uncover("2-3", [$ L_"scatter" = E_"light" F(theta_s) beta_s rho(h_s) T_s T_l $])
  #uncover("3-3", [$ T = exp(-beta_a integral_a^b rho(sqrt(t^2 + h^2 + 2 h t cos theta_v)) d t) $])
  #uncover("4-4", [What if we use numerical integration to solve these equations?])
  
  #figure(
    cetz.canvas(length: 2.5em, {
      import cetz.draw: *
  
      let ocontent(a, b, ..rest) = {
        content(a, { set text(size: 30pt); b }, ..rest)
      }
  
      stroke((thickness: 2pt))
      
      // planet
      arc-through((-5, -1), (0, 0), (5, -1))
  
      // atmosphere
      stroke((dash: "dashed"))
      arc-through((-7.5, 1), (0, 3), (7.5, 1)) // atmosphere
      stroke((dash: none))
  
      // viewer
      fill(black)
      ocontent((-3.3, 0.7), [$v$])
      circle((-3, 1), radius: 0.1)
      fill(none)
  
      // sun
      stroke((dash: "dashed"))
      circle((5, 4), radius: 0.2)
      ocontent((5.4, 3.6), [$l$])
      stroke((dash: none))
  
      // view to scatter
      line((-3, 1), (1, 1))
  
      // scatter to sun
      line((1, 1), (5, 4))
    })
  )
])

== Naive
Results:
#figure(
  grid(
    rows: (auto,),
    columns: (auto, auto),
    gutter: 2em,
    image("naive-space.png", width: 18em),
    image("naive-sunset.png", width: 18em)
  )
)

== Naive
#slide(repeat: 3, self => [
  #let (uncover, only) = utils.methods(self)

  #only(1, [Compared to path tracing])
  #only(2, [Naive has a darker sky (mean absolute error = 0.019)])
  #only(3, [This is due to a lack of multiple scattering])
  
  #figure(
    grid(
      rows: (auto,),
      columns: (auto, auto),
      gutter: 2em,
      figure(image("naive-sunset.png", width: 18em), caption: "Naive"),
      figure(image("pt-sunset.png", width: 18em), caption: "Path traced")
    )
  )
])

== Extending Naive
Can we do better than naive?

#pause

Yes

== Extending Naive
Numerically integrating the optical depth _for each scatter point_ is a lot of work.

#pause

Nishita et al (1993) notice this, and propose a solution:

#pause

Use a lookup table

== Nishita et al
Recall the optical depth integral: $ tau = integral_a^b rho(sqrt(t^2 + h^2 + 2 h t cos theta_v)) d t $

#pause

It only relies on the start height $h$, and direction $theta_v$

#pause

Nishita et al uses this fact to store optical depth $tau$ into a 2D lookup table

== O'Neil
O'Neil (2005) wants to implement this method on the GPU

#pause
For performance reasons:
#pause
- Run the scattering per vertex, not per-pixel
- Allow the GPU to interpolate results for each pixel
 
== O'Neil
O'Neil (2005) wants to implement this method on the GPU

At the time, not all GPUs support texture reads from the vertex shader
#pause
No lookup table possible

== O'Neil
O'Neil (2005) wants to implement this method on the GPU

Instead, fit an equation on the resulting lookup table:
#pause
$ tau = exp(-s_1 h) s_2 exp(5.25x^4 - 6.80x^3 + 3.83x^2 + 0.459x - 0.00287) $
#pause
Works, but equation needs to be fit when atmosphere size changes

== Schuler
Schuler (2012) finds a solution to this: the Chapman function $"Ch"(x, chi)$
#pause
This comes from physics literature, and many approximations of this function exist
#pause

Schuler derives a new one:
$ tau_"Ch" = cases(
    display(& exp(-h / h_0) c / (1 + c cos theta_v) & "if" theta_v < 90 degree),
    display(- & exp(-h / h_0) c/(1 - c cos theta_v) + 2 sqrt(x_0) exp(r / h_0 - x_0)  quad & "otherwise")
) $

Where

$ c = sqrt((r + h) / h_0), quad "and" quad x_0 = sqrt(1 - cos^2 theta_v)((r + h) / h_0) $

== Schuler
Results (Rayleigh only):

#figure(
  grid(
    rows: (auto,),
    columns: (auto, auto),
    gutter: 2em,
    image("schuler-space.png", width: 18em),
    image("schuler-sunset.png", width: 18em)
  )
)

== Schuler
Compared to naive (Rayleigh only):

#figure(
  grid(
    rows: (auto,),
    columns: (auto, auto),
    gutter: 2em,
    figure(image("schuler-sunset.png", width: 18em), caption: "Schuler"),
    figure(image("naive-sunset-ray.png", width: 18em), caption: "Naive")
  )
)

== Schuler
Compared to path tracing (Rayleigh only):

#figure(
  grid(
    rows: (auto,),
    columns: (auto, auto),
    gutter: 2em,
    figure(image("schuler-sunset.png", width: 18em), caption: "Schuler"),
    figure(image("pt-sunset-ray.png", width: 18em), caption: "Path traced"),
  )
)

= But still no multiple scattering!
How do we solve this?

== Bruneton and Neyret
Bruneton and Neyret (2008) have a solution:
#pause
Precompute everything

#pause
- Transmittance (Not optical depth!): #figure(image("transmittance.png", width: 18em), caption: "x = view angle, y = height, color = amount of light let through")
  #pause
- Single scattering: 4D lookup table, all possible height, view angle, sun-horizon and sun-view angles
  #pause
- Multiple scattering: 4D lookup table, incoming radiance for all possible height, view angle, sun-horizon and sun-view angles

== Bruneton and Neyret
Bruneton and Neyret (2008) have a solution:
Precompute everything

Multiple scattering is computed in steps, one step for each extra scatter event

== Bruneton and Neyret
Results:

#figure(
  grid(
    rows: (auto,),
    columns: (auto, auto),
    gutter: 2em,
    image("bruneton-space.png", width: 18em),
    image("bruneton-sunset.png", width: 18em)
  )
)

== Bruneton and Neyret
Compared to path tracing:

#figure(
  grid(
    rows: (auto,),
    columns: (auto, auto),
    gutter: 2em,
    figure(image("bruneton-sunset.png", width: 18em), caption: "Bruneton and Neyret"),
    figure(image("pt-sunset.png", width: 18em), caption: "Path traced")
  )
)

#pause
We now have multiple scattering, but this implementation is rather complex

== Hillaire
Hillaire (2020) proposes a different method:
#pause
Precompute less things

#pause

- Precompute transmittance (same as Bruneton and Neyret)
  #pause
- Compute single scattering at a lower resolution
  #pause
- Approximate multiple scattering
  #pause
I have not implemented this yet

== Hillaire
Results (from the paper):
#figure(image("hillaire-results.png"))

= Fitted models
Fit an equation instead of simulating scattering

== Fitted models
Of note are:
- Preetham et al (1999)
- Hosek and Wilkie (2012)
#pause
These models do not support viewing from higher up from the ground
#figure(image("preetham.png", width: 30em))

== What's  missing?
So far there are two categories of models:
#pause
- Numerical integration, supports all views
- Fitted models, only supports ground views
#pause
Missing is a 3rd one: Fitted model, supporting all views

= Research
What do I want to do

== Research questions
- Is it possible to create a fitted model that supports both ground and space views?
#pause
- How will the performance compare to the previously discussed models?
#pause
- How difficult is it to change this model to different atmospheres, with different $rho(h)$?

== Research
#show "nvidia-flip": "\u{A7FB}LIP"
How will I do this?
- Implement a tool to run all models (done)
- Implement all the different models (almost done)
  #pause
- Implement the new model
  #pause
- Compare the output of the models using RMSE and nvidia-flip
  #figure(image("nvidia-flip.png", width: 22em))
  #pause
- Compare the runtime performance of the models using GPU profiling tools

== New model
Still need to find a good way to fit the model
- Symbolic regression
- Neural networks?
- Polynomial fit?
- Try random equations until something works?
I will probably do this in parts, same way the lookup tables are used
#pause

If you have suggestions, tell me

#focus-slide[Questions? \ Advice?]
