
struct Uni {
    texture: f32,
    layer: f32,
}

@group(0) @binding(12) var<uniform> uni: Uni;

@group(0) @binding(0) var tex: texture_2d<f32>;
@group(0) @binding(8) var vol: texture_3d<f32>;

@group(0) @binding(13) var samp: sampler;

@fragment fn main(
    @location(0) @interpolate(linear, centroid) fragcoord: vec2f
) -> @location(0) vec4f {
    if (uni.texture == 0) {
        return vec4f(textureSample(tex, samp, fragcoord).rgb, 1.0);
    } else {
        return vec4f(textureSample(
            vol,
            samp,
            vec3f(fragcoord, uni.layer / f32(textureDimensions(vol).z))
        ).rgb, 1.0);
    }
}
