import tomllib
import os

def main():
    # load the atmosphere
    atmo = open("atmosphere.toml").read()
    
    # get all views and their parameters
    views = tomllib.load(open("views.toml", "rb"))

    # result
    res = f"# atmosphere\n{atmo}\n\n# setup\n"

    # go over shader setup
    for setup in os.listdir("setup"):
        # add it to the result
        res = f"{res}# setup {setup}\n{open('setup/' + setup).read()}\n"

    res = f"{res}\n# run\n"

    # go over shader views
    for render in os.listdir("render"):
        # generate for each view
        for view, vals in views.items():
            # read
            instrs = open('render/' + render).read()

            # replace all variables in the instructions with those in the view
            for key, val in vals.items():
                instrs = instrs.replace(f"${key}", str(val))

            # replace name
            instrs = instrs.replace("$name", f"{render.removesuffix('.toml')}-{view}")
            
            # add the view to the result
            res = f"{res}{instrs}\n"

    # output final file
    print(res)


if __name__ == "__main__":
    main()
