import glob
import re

# match anything between start and end
delim = re.compile(r'[\s\S]*<START>([\s\S]*)<END>[\s\S]*')

# match multiline comments
multi = re.compile(r'(\/\*[\s\S]+?(?=\*\/)\*\/)')

# see all files in shader
for file in glob.glob('shaders/*.glsl'):
    shader = open(file, 'r').read()

    # cut multilines
    shader = multi.sub('', shader)

    # cut delimiters
    code = delim.match(shader)
    if not code:
        continue
    
    code = code.group(1)

    # count non-empty lines
    count = 0
    for l in code.splitlines():
        l = l.strip()
        if not l.startswith("//") and not l in ["", "{", "}", ")", ");"]:
            count += 1

    print(file, 'is', count)

# bruneton is special
bruneton = open('bruneton/main.glsl').read()
code = delim.match(shader).group(1)
code += open('bruneton/definitions.glsl').read()
code += open('bruneton/functions.glsl').read()
code = multi.sub('', code)

# count non-empty lines
count = 0
for l in code.splitlines():
    l = l.strip()
    if not l.startswith("//") and not l in ["", "{", "}", ")", ");"]:
        count += 1

print('bruneton is', count)
