# A visual and performance comparison of atmospheric scattering models
Master's thesis. Below is an overview of what is inside the repository.

Note that not all files used are inside this repo, and need to be created using
the programs provided in this repo. These are the neural network training data in
`images/tables` and the images to compare, in `images/compare`.

## doc
Presentations and thesis document.
Needs the following:
- `typst`: to compile documents.
- `ttf-dejavu` and `otf-fira-sans`: fonts (package names as available in the arch linux repositories).

The following documents can be compiled:
- `main.typ`: Final thesis document.
- `part1.typ`: Part 1 (proposal) document.
- `final.typ`: Final presentation.
- `present-between/between`: Midterm presentation.

Compiling is done by running `typst c <filename.typ>`, this will output a `.pdf`
file to `<filename.pdf>`.

## mini-shadertoy
Small program to run all shaders on the GPU, and write results out to a file
It needs a GPU that supports vulkan/directx12, with push constants and filterable and blendable `Rgba32Float` textures.

Needs:
- `cargo`: The rust compiler.
- `make`: Compiling the bundle.
- `zip`: Compiling the bundle.

## comparison
All shaders to compare, as well as various tools to compare the resulting images with.
Note that this also needs the same dependencies as `mini-shadertoy`, as it compiles it
when running some of the scripts.
Needs:
- `make`: Run some of the tools.
- `glslalg`: To compile the shaders.
- `uv`: To run the python scripts.

The `Makefile` runs and compiles all shaders. `make short` outputs the images
without the path tracer to `/tmp/imgs`. `make images` outputs all images to
`images/compare`. `make compare` then runs the comparison tool on these images.
`make tables` creates the tables needed for the neural network and other experiments
to run. 

## experiments
Various experiments to fit the atmosphere models.
Needs:
- `uv`: To run the python scripts.

## images
All resulting images from running the shaders, as well as timing results and data
needed for the neural networks. To limit the repo size, these are not included in
the repo. The final images can still be found under `doc/comp/`.

## Shadertoy links:
Links to the shadertoy versions of the shaders implemented. Only Bruneton and
Neyret's atmosphere is not implemented in shadertoy, as it is not possible to
use 3D buffers.
- Flat: https://www.shadertoy.com/view/t3XBWH
- Raymarched: https://www.shadertoy.com/view/tXXBWH
- Neural Network: https://www.shadertoy.com/view/tXffD8
- Preetham, Shirley, Smits': https://www.shadertoy.com/view/WX2Bz1
- Naive: https://www.shadertoy.com/view/W3jBz1
- Schuler: https://www.shadertoy.com/view/WX2fR1
- Hillaire's: https://www.shadertoy.com/view/wcdGRX
- Path tracer: https://www.shadertoy.com/view/Wfd3D8

## License
All code is under the MIT license (see the LICENSE file), unless otherwise specified.
